local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local t = Def.ActorFrame {
	LoadActor("_background") .. {
		Name="BenchmarkBG";
		InitCommand=cmd(shadowlength,3;y,-6;skewx,-0.25;diffuse,PlayerColor(player);fadeleft,1;zoomtowidth,210;diffusealpha,0);
		ShowCommand=cmd(finishtweening;diffuse,1,1,1,1;diffusebottomedge,PlayerColor(player);y,20;diffusealpha,0;bounceend,0.5;glow,1,1,1,1;y,-60;decelerate,0.2;glow,1,1,1,0;diffusealpha,1;queuecommand,"Hide");
		HideCommand=cmd(finishtweening;sleep,3;accelerate,0.3;y,-80;diffusealpha,0);
		OnCommand=cmd(rotationy,(player == PLAYER_1) and 180 or 0);
	};
	LoadFont("Combo", "numbers" ) .. {
		Name="BenchmarkCombo";
		InitCommand=cmd(y,-60;shadowlength,0;zoom,0.95;diffusebottomedge,PlayerColor(player);diffusealpha,0);
		ShowCommand=cmd(finishtweening;diffuse,1,1,1,1;diffusebottomedge,PlayerColor(player);y,20-10;diffusealpha,0;zoom,1.5;bounceend,0.5;glow,1,1,1,1;y,-60-10;decelerate,0.2;glow,1,1,1,0;zoom,1;diffusealpha,1;queuecommand,"Hide");
		HideCommand=cmd(finishtweening;sleep,3;accelerate,0.3;y,-80-10;diffusealpha,0);
		MissCommand=cmd(finishtweening;linear,0.1;diffusealpha,1;glow,1,1,1,1;decelerate,0.3;glow,1,1,1,0;diffuse,cRed;wag;sleep,2;linear,0.3;zoom,0;diffusealpha,0);
	};
	LoadFont("Common Normal") .. {
		Name="BenchmarkText";
		Text="COMBO";
		InitCommand=cmd(y,-60+23-10;NoStroke;shadowlength,0;zoom,0.75;diffuse,cBlue;diffusetopedge,LightColor(cBlue);diffusealpha,0);
		ShowCommand=cmd(finishtweening;diffuse,1,1,1,1;diffusebottomedge,PlayerColor(player);y,20+23-10;diffusealpha,0;zoom,1.15;bounceend,0.5;glow,1,1,1,1;y,-60+23-10;decelerate,0.2;zoom,0.75;glow,1,1,1,0;diffusealpha,1;queuecommand,"Hide");
		HideCommand=cmd(finishtweening;sleep,3;accelerate,0.3;y,-80+23-10;diffusealpha,0);
		MissCommand=cmd(finishtweening;linear,0.1;diffusealpha,1;glow,1,1,1,1;decelerate,0.3;glow,1,1,1,0;diffuse,cRed;wag;sleep,2;linear,0.3;zoom,0;diffusealpha,0);
	};
	LoadActor("_background") .. {
		Name="BG";
		InitCommand=cmd(shadowlength,3;y,-6;skewx,-0.25;diffuse,PlayerColor(player);fadeleft,1;zoomtowidth,210);
		OnCommand=cmd(zoomx,(player == PLAYER_1) and 1 or -1);
	};
	LoadFont( "Combo", "numbers" ) .. {
		Name="Number";
		InitCommand=cmd(x,(player == PLAYER_1) and (192/2) or (-192/2));
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
--[[ 	LoadActor("_combo") .. {
		Name="ComboLabel";
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
	LoadActor("_misses") .. {
		Name="MissesLabel";
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	}; --]]
    LoadFont("Common Normal") .. {
        Text="+";
		Name="ComboLabel";
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
    
    LoadFont("Common Normal") .. {
        Text="-";
		Name="MissesLabel";
        BeginCommand = cmd(diffuse,JudgeColor('TapNoteScore_Miss'));
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
    
	InitCommand = function(self)
		c = self:GetChildren();
		c.BG:visible(false);
		c.Number:visible(false);
		c.ComboLabel:visible(false);
		c.MissesLabel:visible(false);
		c.Number:skewx((player == PLAYER_1) and -0.25 or 0.25);
		c.Number:horizalign((player == PLAYER_1) and right or left);
	end;

	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
        local isCombo = (param.Combo) and true or false;
        local Addendum = (param.Combo) and "" or "-";
		if not iCombo or iCombo < ShowComboAt then
			c.BG:visible(false);
			c.Number:visible(false);
			c.ComboLabel:visible(false);
			c.MissesLabel:visible(false);
			c.BenchmarkCombo:visible(false);
			c.BenchmarkText:visible(false);
			c.BenchmarkBG:visible(false);
			return;
		end

        
		local Label;
		if param.Combo then
			Label = c.ComboLabel;
		else
			Label = c.MissesLabel;
		end
		-- reset the label's visibility so we don't accidentally draw both labels
		Label:visible(false);
		c.BG:visible(false);
-- 		c.BenchmarkText:visible(false);
-- 		c.BenchmarkCombo:visible(false);
		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );
 		c.Number:visible(true);
		Label:visible(true);
		c.BG:visible(true);

		c.Number:settext( Addendum .. iCombo );
		c.Number:diffuse( isCombo and color(1,1,1,1) or cRed );
--~ 		c.Number:settext( string.format("%i", Addendum .. iCombo) );
--~ 		c.Number:settext( string.format("%i", iCombo) .. "." .. prevToastyRequirement )

		Pulse( c.Number, param );
		Pulse( Label, param );
		
		if (iCombo > 50) and isCombo then
			if (iCombo % 25) == 0 then
				c.BG:finishtweening();
				c.BG:zoom(1.2);
				c.BG:decelerate(0.3);
				c.BG:zoom(1);
			else
				return
			end
		end
		
		if (iCombo > 75) and isCombo then
			if (iCombo % 100) == 0 then
				c.BenchmarkBG:visible(true);
				c.BenchmarkBG:playcommand("Show");
				c.BenchmarkText:visible(true);
				c.BenchmarkText:playcommand("Show");
				c.BenchmarkCombo:settext(iCombo);
				c.BenchmarkCombo:visible(true);
				c.BenchmarkCombo:playcommand("Show");
			else
				return
			end
		end
	end;
};

return t;
